<?php
session_start();
require_once 'config.php';

echo "<h1>Admin Profile Debug</h1>";

// Check session
echo "<h3>Session Data:</h3>";
echo "<pre>";
print_r($_SESSION);
echo "</pre>";

// Check if logged in
if (!isset($_SESSION['user_id'])) {
    echo "<div style='background: #ffe5e5; padding: 10px; color: red;'><strong>ERROR:</strong> Not logged in. Session user_id not set.</div>";
    exit;
}

$user_id = $_SESSION['user_id'];
$user_type = $_SESSION['user_type'] ?? 'unknown';

echo "<h3>Login Status:</h3>";
echo "User ID: <strong>$user_id</strong><br>";
echo "User Type: <strong>$user_type</strong><br>";

// Check in users table
echo "<h3>Check Users Table:</h3>";
$query = "SELECT id, name, email, phone, user_type FROM users WHERE id = $user_id";
$result = $conn->query($query);

if ($result && $result->num_rows > 0) {
    $user = $result->fetch_assoc();
    echo "<div style='background: #e5ffe5; padding: 10px; color: green;'><strong>SUCCESS:</strong> User found in users table</div>";
    echo "<pre>";
    print_r($user);
    echo "</pre>";
} else {
    echo "<div style='background: #ffe5e5; padding: 10px; color: red;'><strong>ERROR:</strong> User NOT found in users table with ID $user_id</div>";
}

// Test API call
echo "<h3>Test API Call:</h3>";
echo "<p>URL: api_handler.php?action=get_admin_profile</p>";
echo "<p>Expected: JSON with admin profile data from users table</p>";

// Simulate API call
$_GET['action'] = 'get_admin_profile';
include 'api_handler.php';
?>
